// H. Moessenboeck: Sprechen Sie Java? -- Kapitel 11, Aufgabe 1
// "Zahlenmengen"

// Sets of integers between 0 and 31
class Set {
	int set = 0;
	
	void include(int x) {
		if (x >= 0 && x < 32) set |= 1 << x;
	}
	
	void exclude(int x) {
		if (x >= 0 && x < 32) set &= ~(1 << x);
	}
	
	boolean contains(int x) {
		return x >= 0 && x < 32 && ((1 << x) & set) != 0;
	}
	
	void union(Set s) {
		set |= s.set;
	}
	
	void intersect(Set s) {
		set &= s.set;
	}
	
	public String toString() {
		StringBuffer b = new StringBuffer();
		boolean first = true;
		b.append("{");
		for (int i = 0; i < 32; i++)
			if (contains(i)) {
				if (first) first = false; else b.append(",");
				b.append(i);
			}
		b.append("}");
		return b.toString();
	}
}

public class A1 {
	
	public static void main(String args[]) {
		Set s = new Set();
		s.include(3);
		s.include(5);
		Out.println("s = " + s);
		
		Set s1 = new Set();
		s1.include(5);
		s1.include(6);
		s1.include(10);
		s.union(s1);
		Out.println("s = " + s);
		
		s1 = new Set();
		s1.include(3);
		s1.include(10);
		s.intersect(s1);
		Out.println("s = " + s);
		
		s.exclude(10);
		Out.println("s = " + s);
	}
}
